<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

global $webdados_fb;

?>
<div class="menu_containt_div" id="tabs-6">
	<p><?php _e( 'Settings for 3rd party integration with other plugins.', 'wonderm00ns-simple-facebook-open-graph-tags' ); ?></p>
	<!-- Yoast SEO and All in One SEO Pack? -->
	<?php
	if ( $webdados_fb->is_yoast_seo_active() && $webdados_fb->is_aioseop_active() ) {
		?>
		<p>
			<i class="dashicons-before dashicons-warning"></i>
			<strong><?php _e( 'Attention', 'wonderm00ns-simple-facebook-open-graph-tags' ); ?>:</strong>
			<br/>
			<?php _e( 'You currently have both Yoast SEO and All in One SEO Pack plugins active. This is no recommended.', 'wonderm00ns-simple-facebook-open-graph-tags' ); ?>
		</p>
		<?php
	}
	?>
	<!-- Yoast SEO -->
	<div class="postbox">
		<h3 class="hndle">
			<?php
			if ( $webdados_fb->is_yoast_seo_active() && class_exists('WPSEO_Utils') ) {
				$wpseo_utils = new WPSEO_Utils();
				if( method_exists($wpseo_utils, 'get_icon_svg') ) {
					?>
					<img src="<?php echo 'data:image/svg+xml;base64,' . base64_encode( str_replace('fill:#82878c', 'fill:#23282d', $wpseo_utils->get_icon_svg(false) ) ) ; ?>"/>
					<?php
				} else {
					?><i class="dashicons-before dashicons-editor-code"></i><?php
				}
			} else {
				?><i class="dashicons-before dashicons-editor-code"></i><?php
			}
			?>
			<a href="https://wordpress.org/plugins/wordpress-seo/" target="_blank">Yoast SEO</a>
		</h3>
		<div class="inside">
			<?php
			if ( $webdados_fb->is_yoast_seo_active() ) {
				?>
				<table class="form-table">
					<tbody>
						
						<tr>
							<th><?php _e( 'Use Title, URL and Description', 'wonderm00ns-simple-facebook-open-graph-tags' ); ?>:</th>
							<td>
								<input type="checkbox" name="wonderm00n_open_graph_settings[fb_show_wpseoyoast]" id="fb_show_wpseoyoast" value="1" <?php echo (intval($options['fb_show_wpseoyoast'])==1 ? ' checked="checked"' : ''); ?>/>
							</td>
						</tr>
						<tr>
							<td colspan="2" class="info">
								- <?php _e( 'Use Title, Canonical URL and Description generated by Yoast SEO', 'wonderm00ns-simple-facebook-open-graph-tags' ); ?>
							</td>
						</tr>
						
						<tr>
							<td colspan="2">
								<i class="dashicons-before dashicons-warning"></i>
								<b><?php _e( 'Attention', 'wonderm00ns-simple-facebook-open-graph-tags' ); ?>:</b>
								<br/>
								<small>
									<?php printf( __( 'Because you are using Yoast SEO, and to avoid duplicate social tags, you should disable their social settings at <a href="%s" target="_blank">Yoast SEO &gt; Social</a>. If you cannot access that page, you must first activate the "Advanced settings pages" at <a href="%s" target="_blank">Yoast SEO &gt; Dashboard &gt; Features</a>.', 'wonderm00ns-simple-facebook-open-graph-tags' ), 'admin.php?page=wpseo_social', 'admin.php?page=wpseo_dashboard#top#features' ); ?>
								</small>
							</td>
						</tr>
						<tr>
							<td colspan="2" class="info">
							</td>
						</tr>
	
					</tbody>
				</table>
				<?php
			} else {
				?>
				<p><?php printf ( __( 'You don\'t have %s installed or activated.', 'wonderm00ns-simple-facebook-open-graph-tags' ), 'Yoast SEO' ); ?></p>
				<?php
			}
			?>
		</div>
	</div>
	<!-- All in One SEO Pack -->
	<input type="hidden" name="wonderm00n_open_graph_settings[fb_show_aioseop]" id="fb_show_aioseop" value="0"/>
	<!--<div class="postbox">
		<h3 class="hndle">
			<i class="dashicons-before dashicons-shield-alt"></i>
			<a href="https://wordpress.org/plugins/all-in-one-seo-pack/" target="_blank">All in One SEO Pack</a>
		</h3>
		<div class="inside">
			<?php
			if ( $webdados_fb->is_aioseop_active() ) {
				?>
				<table class="form-table">
					<tbody>
						
						<tr>
							<th><?php _e( 'Use Title and Description', 'wonderm00ns-simple-facebook-open-graph-tags' ); ?>:</th>
							<td>
								<input type="checkbox" name="wonderm00n_open_graph_settings[fb_show_aioseop]" id="fb_show_aioseop" value="1" <?php echo (intval($options['fb_show_aioseop'])==1 ? ' checked="checked"' : ''); ?>/>
							</td>
						</tr>
						<tr>
							<td colspan="2" class="info">
								- <?php _e( 'Use Title and Description generated by All in One SEO Pack', 'wonderm00ns-simple-facebook-open-graph-tags' ); ?>
							</td>
						</tr>
						
						<tr>
							<td colspan="2">
								<i class="dashicons-before dashicons-warning"></i>
								<strong><?php _e( 'Attention', 'wonderm00ns-simple-facebook-open-graph-tags' ); ?>:</strong>
								<br/>
								<small>
									<?php printf( __( 'Because you are using All in One SEO Pack, and to avoid duplicate social tags, you should disable their social settings at <a href="%s" target="_blank">MISSING LINK</a>.', 'wonderm00ns-simple-facebook-open-graph-tags' ), '#' ); ?>
								</small>
							</td>
						</tr>
						<tr>
							<td colspan="2" class="info">
							</td>
						</tr>
	
					</tbody>
				</table>
				<?php
			} else {
				?>
				<p><?php printf ( __( 'You don\'t have %s installed or activated.', 'wonderm00ns-simple-facebook-open-graph-tags' ), 'All in One SEO Pack' ); ?></p>
				<?php
			}
			?>
		</div>
	</div>-->
	<!-- WooCommerce -->
	<div class="postbox">
		<h3 class="hndle">
			<i class="dashicons-before dashicons-cart"></i>
			<a href="https://wordpress.org/plugins/woocommerce/" target="_blank">WooCommerce</a>
		</h3>
		<div class="inside">
			<?php
			if ( $webdados_fb->is_woocommerce_active() ) {
				?>
				<p><?php _e('On the product page we will automatically set <i>og:type</i> to "product" and <i>product:price</i> to the price including tax.', 'wonderm00ns-simple-facebook-open-graph-tags'); ?></p>
				<table class="form-table">
					<tbody>
						
						<tr>
							<th><?php _e( 'Use Product Gallery as Images', 'wonderm00ns-simple-facebook-open-graph-tags' ); ?>:</th>
							<td>
								<input type="checkbox" name="wonderm00n_open_graph_settings[fb_wc_useproductgallery]" id="fb_wc_useproductgallery" value="1" <?php echo (intval($options['fb_wc_useproductgallery'])==1 ? ' checked="checked"' : ''); ?>/>
							</td>
						</tr>
						<tr>
							<td colspan="2" class="info">
								- <?php _e('Sets each Product Gallery image as an additional <i>og:image</i> tag so that, when a product is shared on Facebook, the user is given the choice what image to display', 'wonderm00ns-simple-facebook-open-graph-tags'); ?>
								<br/>
								- <?php printf( __( 'You can change this value using the <i>%1$s</i> filter', 'wonderm00ns-simple-facebook-open-graph-tags' ), 'fb_og_image_additional' ); ?>
							</td>
						</tr>
					
						<tr class="fb_image_overlay_options">
							<th><?php _e( 'Overlay PNG logo', 'wonderm00ns-simple-facebook-open-graph-tags' ); ?>:</th>
							<td>
								<input type="checkbox" name="wonderm00n_open_graph_settings[fb_wc_usepg_png_overlay]" id="fb_wc_usepg_png_overlay" value="1" <?php echo (intval($options['fb_wc_usepg_png_overlay'])==1 ? ' checked="checked"' : ''); ?>/>
							</td>
						</tr>
						<tr class="fb_image_overlay_options">
							<td colspan="2" class="info">
								- <?php _e( 'Also overlay the PNG logo on the Product Gallery images', 'wonderm00ns-simple-facebook-open-graph-tags' ); ?>
							</td>
						</tr>
						
						<tr>
							<th><?php _e( 'Use Category thumbnail as Image', 'wonderm00ns-simple-facebook-open-graph-tags' ); ?>:</th>
							<td>
								<input type="checkbox" name="wonderm00n_open_graph_settings[fb_wc_usecategthumb]" id="fb_wc_usecategthumb" value="1" <?php echo (intval($options['fb_wc_usecategthumb'])==1 ? ' checked="checked"' : ''); ?>/>
							</td>
						</tr>
						<tr>
							<td colspan="2" class="info">
								- <?php _e('Recommended if you set large thumbnails for Product Categories and want to use them as Open Graph Images on category listing pages', 'wonderm00ns-simple-facebook-open-graph-tags'); ?>
								<br/>
								- <?php _e('This setting also applies to brand pages if WooCommerce Brands is installed', 'wonderm00ns-simple-facebook-open-graph-tags'); ?>
							</td>
						</tr>
	
					</tbody>
				</table>
				<?php
			} else {
				?>
				<p><?php printf ( __( 'You don\'t have %s installed or activated.', 'wonderm00ns-simple-facebook-open-graph-tags' ), 'WooCommerce' ); ?></p>
				<?php
			}
			?>
		</div>
	</div>
	<!-- SubHeading -->
	<div class="postbox">
		<h3 class="hndle">
			<i class="dashicons-before dashicons-editor-textcolor"></i>
			<a href="https://wordpress.org/plugins/subheading/" target="_blank">SubHeading</a>
		</h3>
		<div class="inside">
			<?php
			if ( $webdados_fb->is_subheading_plugin_active() ) {
				?>
				<table class="form-table">
					<tbody>
						
						<tr>
							<th><?php _e( 'Add SubHeading to Post/Page Title', 'wonderm00ns-simple-facebook-open-graph-tags' ); ?>:</th>
							<td>
								<input type="checkbox" name="wonderm00n_open_graph_settings[fb_show_subheading]" id="fb_show_subheading" value="1" <?php echo (intval($options['fb_show_subheading'])==1 ? ' checked="checked"' : ''); ?>/>
							</td>
						</tr>
						<tr>
							<td colspan="2" class="info">
							</td>
						</tr>
						
						<tr class="fb_subheading_options">
							<th><?php _e( 'SubHeading position', 'wonderm00ns-simple-facebook-open-graph-tags' ); ?>:</th>
							<td>
								<select name="wonderm00n_open_graph_settings[fb_subheading_position]" id="fb_subheading_position">
									<option value=""<?php if (trim($options['fb_subheading_position'])=='after') echo ' selected="selected"'; ?>><?php _e('After', 'wonderm00ns-simple-facebook-open-graph-tags');?></option>
									<option value="before"<?php if (trim($options['fb_subheading_position'])=='before') echo ' selected="selected"'; ?>><?php _e('Before', 'wonderm00ns-simple-facebook-open-graph-tags');?></option>
								</select>
							</td>
						</tr>
						<tr class="fb_subheading_options">
							<td colspan="2" class="info">
							</td>
						</tr>
							
					</tbody>
				</table>
				<?php
			} else {
				?>
				<p><?php printf ( __( 'You don\'t have %s installed or activated.', 'wonderm00ns-simple-facebook-open-graph-tags' ), 'SubHeading' ); ?></p>
				<?php
			}
			?>
		</div>
	</div>
	<!-- Business Directory -->
	<div class="postbox">
		<h3 class="hndle">
			<i class="dashicons-before dashicons-id"></i>
			<a href="https://wordpress.org/plugins/business-directory-plugin/" target="_blank">Business Directory Plugin</a>
		</h3>
		<div class="inside">
			<?php
			if ( $webdados_fb->is_business_directory_active() ) {
				?>
				<table class="form-table">
					<tbody>
						
						<tr>
							<th><?php _e( 'Use listing details', 'wonderm00ns-simple-facebook-open-graph-tags' ); ?>:</th>
							<td>
								<input type="checkbox" name="wonderm00n_open_graph_settings[fb_show_businessdirectoryplugin]" id="fb_show_businessdirectoryplugin" value="1" <?php echo (intval($options['fb_show_businessdirectoryplugin'])==1 ? ' checked="checked"' : ''); ?>/>
							</td>
						</tr>
						<tr>
							<td colspan="2" class="info">
								- <?php _e( 'Use Business Directory Plugin listing details (Title, URL, Description and Image) to populate tags', 'wonderm00ns-simple-facebook-open-graph-tags' ); ?>
								<br/>
								- <?php _e( 'Setting "Include URL", "Set Canonical URL", "Include Description" and "Include Image" options is HIGHLY recommended', 'wonderm00ns-simple-facebook-open-graph-tags' ); ?>
							</td>
						</tr>
							
					</tbody>
				</table>
				<?php
			} else {
				?>
				<p><?php printf ( __( 'You don\'t have %s installed or activated.', 'wonderm00ns-simple-facebook-open-graph-tags' ), 'Business Directory Plugin' ); ?></p>
				<?php
			}
			?>
		</div>
	</div>
</div>